/*
 * %CopyrightBegin%
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Copyright Kjell Winblad 2019. All Rights Reserved.
 * Copyright Ericsson AB 2019-2025. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * %CopyrightEnd%
 */

/*
 * Description:
 *
 * Author: Kjell Winblad
 *
 */


#include <stdio.h>
#include <stdlib.h>

#define YCF_YIELD()


void sub_fun_1(char* res, char x, char y){
  printf("sub_fun_1_1\n");
  YCF_YIELD();
  printf("sub_fun_1_2\n");
  *res = x + y;
  YCF_YIELD();
  printf("sub_fun_1_3\n");
  YCF_YIELD();
  printf("sub_fun_1_4\n");
}

void sub_fun_2(){
  printf("sub_fun_2_1\n");
  YCF_YIELD();
  printf("sub_fun_2_2\n");
}

char sub_fun_3(char x, char y){
  char res;
  printf("sub_fun_2_1\n");
  YCF_YIELD();
  res = x + y;
  YCF_YIELD();
  printf("sub_fun_2_2\n");
  return res;
}

int fun(char x){
  char y;
  char z = 10
  YCF_YIELD();
  sub_fun_1(&y,x,1); /* y == 2 */
  YCF_YIELD();
  sub_fun_2();
  YCF_YIELD();
  y = sub_fun_3(y, 1); /* y == 3 */
  YCF_YIELD();
  return y + z;
}

void* allocator(size_t size, void* context){
  (void)context;
  return malloc(size);
}

void freer(void* data, void* context){
  (void)context;
  free(data);
}

int main( int argc, const char* argv[] )
{
#ifdef YCF_YIELD_CODE_GENERATED
  void* wb = NULL;
#endif
  int ret = 0;
  long nr_of_reductions = 1;
#ifdef YCF_YIELD_CODE_GENERATED
  do{
    ret = fun_ycf_gen_yielding(&nr_of_reductions,&wb,NULL,allocator,freer,NULL,0,NULL,1);
    if(wb != NULL){
      printf("TRAPPED\n");
    }
  }while(wb != NULL);
  if(wb != NULL){
    free(wb);
  }
#else
  fun(1);
#endif
  printf("RETURNED %d\n", ret);
  if(ret != 13){
    return 1;
  }else{
    return 0;
  }
}
