# Jasmine Core 3.8 Release Notes

## Summary

This is a maintenance release of Jasmine with a number of new features and fixes.

## Python deprecation

The Jasmine packages for Python are deprecated. We intend to continue releasing 
them through the end of the 3.x series, but after that they will be
discontinued. We recommend migrating to the following alternatives:
    
* The [jasmine-browser-runner](https://github.com/jasmine/jasmine-browser)
  npm package to run specs in browsers, including headless Chrome and 
  Saucelabs. This is the most direct replacement for the `jasmine server`
  and `jasmine ci` commands provided by the `jasmine` Python package.
* The [jasmine](https://github.com/jasmine/jasmine-npm) npm package (
  `npm install jasmine`) to run specs under Node.js.
* The standalone distribution from the
  [latest Jasmine release](https://github.com/jasmine/jasmine/releases) to 
  run specs in browsers with no additional tools.
* The [jasmine-core](https://github.com/jasmine/jasmine) npm package if all
  you need is the Jasmine assets. This is the direct equivalent of the 
  jasmine-core Python package.


## New features and bug fixes
      
* Fixed spec filtering in Karma
    * Merges [#1920](https://github.com/jasmine/jasmine/pull/1920) from @jlpstolwijk
    * Fixes [#1906](https://github.com/jasmine/jasmine/issues/1906)

* Added expectAsync(...).already
    * Causes async matchers to immediately fail if the promise is pending
    * See https://jasmine.github.io/api/3.8/async-matchers.html#already
    * Fixes [#1845](https://github.com/jasmine/jasmine/issues/1845)
    
* Include rejection details in failure messages for toBeResolved and toBeResolvedWith

* Fixed "stop spec on expectation failure" checkbox in standalone

* Added option for spyOnAllFunctions to include non-enumerable props
    * Makes spyOnAllFunctions work on instance methods of ES6 classes
    * Merges [#1909](https://github.com/jasmine/jasmine/pull/1909) from @Dari-k
    * Fixes [#1897](https://github.com/jasmine/jasmine/issues/1897)
    
* Added Spy#calls#thisFor
    * Provides the `this` value for a given spy call
    * Merges [#1903](https://github.com/jasmine/jasmine/pull/1903) from @ajvincent

* Improved handling of unhandled promise rejections with no error in Node
    * Fixes [#1759](https://github.com/jasmine/jasmine/issues/1759)


## Documentation updates

* Updated package description

* Updated contributing guide

* Added TypeScript typings and jasmine-browser-runner to issue template

* Removed constructors from jsdocs of classes that aren't user-constructable

* Fixed config.seed type in jsdocs
    * Merges [#1892](https://github.com/jasmine/jasmine/pull/1892) from @UziTech

* Added jsdocs for the following:
    * asymmetric equality testers
    * Env#execute
    * Env#allowRespy
    * The public portion of Spec
    * Spy.callData.returnValue
    * Env#topSuite and Suite
    
* Added a jsdoc cross-reference from Configuration to its usage

* Added a note about correct usage of async matchers

* Added support for ArrayBuffers to matchersUtil.equals
    * Merges [#1891](https://github.com/jasmine/jasmine/pull/1892) from @Finesse
    * Merges [#1689](https://github.com/jasmine/jasmine/pull/1892) from @dankurka
    * Fixes [#1687](https://github.com/jasmine/jasmine/issues/1687)


## Internal notes

* Fixed typo in spec name
    * Merges [#1918](https://github.com/jasmine/jasmine/pull/1918) from @eltociear
    
* Specify files to include in the NPM package rather than files to exclude

* Added test coverage for MatchersUtil#equals with typed arrays

* Removed checks for typed array support in the test suite
    * All supported browsers have all typed arrays except for Uint8ClampedArray,
      BigInt64Array, and BigUint64Array.
      
* Fixed test failures on IE 10

* Test matrix updates
    * Added Node 16
    * Added Safari 14
    * Added Firefox 78 (closest match to current ESR)
    * Removed Safari 10-12 to speed up CI. The newer and older versions we test
      provide a good measure of safety.
      
* Replaced node-sass dev dependency that isn't compatible with Node 16

* Removed unused dev dependencies

* Migrated CI from Travis to Circle

* Compensate for clock jitter in specs


## Supported environments

jasmine-core 3.8.0 has been tested in the following environments.

| Environment       | Supported versions |
|-------------------|--------------------|
| Node              | 10, 12, 14, 16     |
| Safari            | 8-14               |
| Chrome            | 91                 |
| Firefox           | 89, 68, 78         |
| Edge              | 91                 |
| Internet Explorer | 10, 11             |

------

_Release Notes generated with _[Anchorman](http://github.com/infews/anchorman)_
