---
myst:
  html_meta:
    keywords: LaTeX, composition, annexes, bibliographie, syntaxe,  
              majuscules, capitales, titres
---

# Comment conserver les majuscules dans les titres ?

Certains styles bibliographiques, notamment les 
[styles standards de BibTeX](/3_composition/annexes/bibliographie/style_bst/choisir_un_style_de_bibliographie), 
ont la mauvaise habitude de passer les titres des ouvrages cités en minuscules
(sauf, bien sûr, la première lettre).

```
% Un fichier BIB créé par le document avec l'environnement filecontents
\begin{filecontents}[nosearch,overwrite]{mabiblio.bib}
  @Book{kluth,
    author    = "Kluth, Marie-Paule",
    title     = "FAQ \LaTeX\ française",
    publisher = "Vuibert",
    year      = "1999"
  }
\end{filecontents}

% Le document LaTeX
\documentclass[french]{article}
  \usepackage[T1]{fontenc}       % Encodage T1 (adapté au français)
  \usepackage{lmodern}           % Caractères plus lisibles
  \usepackage{babel}             % Réglages linguistiques (avec french)  
  \pagestyle{empty}              % N'affiche pas de numéro de page

\begin{document}
L'ouvrage de Mme Kluth\cite{kluth} a ouvert le chemin à cette FAQ.
\bibliographystyle{plain}
\bibliography{mabiblio}
\end{document}
```

Dans l'exemple ci-dessus, il est bien indiqué "FAQ" dans la bibliographie 
mais, si le style que vous utilisez vous restitue "Faq", ce qui suit 
pourra vous intéresser.

Notez que, typographiquement, cela n'est pas déraisonnable au vu 
des usages courants en anglais (les règles proviennent du 
*Chicago Manual of Style*), mais c'est gênant pour les acronymes, 
les formules chimiques, les noms propres, etc.


## Cas classique

Pour éviter ce problème, vous pouvez utiliser le fait que BibTeX ne touche pas
les lettres qui sont dans des accolades. Vous pouvez donc coder, par exemple, 
ainsi :

```bibtex
title = {Analyse de l'{ADN} du {Brontosaure}},
```

Parfois, BibTeX change la casse d'une seule lettre de manière inappropriée.
Peu importe : la technique peut être appliquée à des lettres uniques, 
comme ici :

```bibtex
title = {Te{X}niques et astuces},
```

Mais les accolades peuvent empêcher le crénage entre les lettres, 
c'est pourquoi il est généralement préférable d'entourer les mots entiers
et pas seulement les lettres individuelles d'accolades pour les protéger.

Si votre maquette de document demande un style de capitalisation différent,
vous devriez choisir un style de bibliographie qui n'applique pas les règles
par défaut de BibTeX.

Notez que mettre un titre entier entre accolades n'est pas une bonne idée, 
comme dans l'exemple suivant :

```bibtex
title = {{TeXniques et astuces}},
```

Si cela garantit que la capitalisation n'est pas modifiée, 
votre base de données BibTeX doit rester une base de données à usage général,
et non se plier aux exigences d'un document ou d'un style bibliographique 
particulier, ou à la façon dont vous pensez aujourd'hui. Vous pourrez avoir
plus tard à utiliser un style BibTeX différent, avec des règles 
de capitalisation différentes.

Vous trouverez plus d'informations sur le sujet dans 
[la documentation sur BibTeX](/1_generalites/documentation/documents/documentation_sur_bibtex).


## Cas des formules chimiques

Dans le cas particulier de formules chimiques, une bonne façon de faire 
est d'utiliser l'extension <ctanpkg:mhchem>, qui fournit la commande `\ce`
(pour **c***hemical* **e***quation*) pour mettre en forme les formules. 
Elle s'occupera également de protéger son contenu contre les modifications
par BibTeX :

```bibtex
title = {Noyade dans un verre d'\ce{H2O}},
```

Notez que l'extension <ctanpkg:chemformula> permet la même chose 
avec sa commande `\ch`.


:::{sources}
- [Capitalisation in BibTeX](faquk:FAQ-capbibtex)
- [BibTeX loses capitals when creating .bbl file](https://tex.stackexchange.com/q/10772),
  sur [Tex Stack Exchange](https://tex.stackexchange.com/)
- [Preserving capitalization in BibTeX titles](https://tex.stackexchange.com/q/7288),
  sur [Tex Stack Exchange](https://tex.stackexchange.com/)
- [How to write chemical formulas in the title field of .bib file?](https://tex.stackexchange.com/q/301785),
  sur [Tex Stack Exchange](https://tex.stackexchange.com/)
- [Distinction entre capitale et majuscule](wpfr:Capitale_et_majuscule)
:::